## Function inputs: 	se, fe, sc, fc = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						a, b = parameters of Beta(a, b) prior distribution of pC representing what is known without the MYCYC data
##						lCparam, lEparam = parameters (mean, variance) of normal prior distributions for lambdaC and lambdaE
##						mu, sigma2 = mean, variance of normal prior for theta representing what is known without the MYCYC data
##						mycyc = vector containing summaries of mycyc data
##						priNormEC = normalising constant of prior density for (pE, pC)|zr, where zr = mycyc data
## Function returns: dataframe containing summaries of posterior distribution of pE (mean, mode, SD) when priors incorporate MYCYC data
D2post_pe <- function(se, fe, sc, fc, a, b, lCparam, lEparam, mu, sigma2, mycyc, priNormEC){
	
	gridc = seq(0.001, 0.999, by=0.001)
	midp1 = (0.00001 + 0.001)*0.5
	midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)

    wc  = vector(mode="numeric", length=lc)
    wc[1] = (gridc[3]-gridc[1])/6.0
    wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
    for(i in seq(2, lc-1, by=2)){
		wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
	}
    for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
	} 
	
	gridca = gridc
	gridea = gridc
	gride = gridc
	we = wc
	le = lc
	
	intpca = vector(mode="numeric", length = lc)
	intpe = vector(mode="numeric", length = le)
	denspc = vector(mode = "numeric", length = lc)
	
	for(j in 1:lc){
  		const1 = dnorm(log(gridca*(1-gridc[j])/(gridc[j]*(1-gridca))), mean = lCparam[1], sd = sqrt(lCparam[2]))
    	dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    	intpca[j] = sum(we*dens)
  	}

  	for(i in 1:le){
  		const1 = dnorm(log(gridea*(1-gride[i])/(gride[i]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    	dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
		intpea = sum(we*dens)
  		for(j in 1:lc){	
    		const1 = dnorm(log(gride[i]*(1-gridc[j])/(gridc[j]*(1 - gride[i]))), mean = mu, sd = sqrt(sigma2))
    		denspc[j] = priNormEC*const1*intpca[j]*intpea*dbeta(gridc[j], shape1=a, shape2=b)/(gride[i]*(1-gride[i]))
    		denspc[j] = denspc[j]*(gridc[j]^sc)*((1-gridc[j])^fc)
  		}
  		intpe[i] = sum(wc*denspc)*(gride[i]^se)*((1-gride[i])^fe)
  	}
	
	postNormEC = 1/sum(we*intpe)
	intpe = postNormEC*intpe
	
	## Calculate summaries of the posterior distribution of pE
	## Checking to see whether posterior marginal probability that pE is in [0.001, 0.999] is less
   	## than would be the case under a flat Beta(1,1) density.
   	lim1 = as.double(0.001)
	lim2 = as.double(0.999)
	
   	gride1 = gride[which(gride >= lim1 & gride <= lim2)]
   	int1 = intpe[which(gride >= lim1 & gride <= lim2)]
   	le1 = length(gride1)
   	we1  = vector(mode="numeric", length=le1)
  	we1[1] = (gride1[3]-gride1[1])/6.0
  	we1[le1] = (gride1[le1] - gride1[le1-2])/6.0
 	for(i in seq(2, (le1-1), by=2)){
		we1[i] = 4*(gride1[i+1] - gride1[i-1])/6.0
	}
	for(i in seq(3, (le1-2), by=2)){
    	we1[i] = (gride1[i+2] - gride1[i-2])/6.0
 	}
    istop = sum(we1*int1)
   	if(istop < (lim2 - lim1)){
      	stop("Error evaluating posterior density of pE:can't guarantee accuracy of numerical integration routines when integrating U (or L) shaped function ")
   	}else{
		## Run this part of the code to evaluate mean and variance of pE
		expect = sum(we*gride*intpe)
		sdev = sqrt(sum(we*gride*gride*intpe) - (expect^2))
		modecal = data.frame(gride, intpe)
		modecal_sort = modecal[order(intpe, decreasing = TRUE), ]
		mode1 = modecal_sort$gride[1]	
		   
   		ci_low = 0
   		ci_upp = 0 			
    	return(data.frame(expect, sdev, mode1, ci_low, ci_upp)) 
    }	
}

## Function inputs: 	se, fe, sc, fc = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						a, b = parameters of Beta(a, b) prior distribution of pC representing what is known without the MYCYC data
##						lCparam, lEparam = parameters (mean, variance) of normal prior distributions for lambdaC and lambdaE
##						mu, sigma2 = mean, variance of normal prior for theta representing what is known without the MYCYC data
##						mycyc = vector containing summaries of mycyc data
##						priNormEC = normalising constant of prior density for (pE, pC)|zr, where zr = mycyc data
## Function returns: dataframe containing summaries of posterior distribution of pC (mean, mode, SD) when priors incorporate MYCYC data
##					and postNormEC = normalising constant for the joint posterior density of (pE, pC)|data, zr, where data = (se, fe, sc, fc) and zr = mycyc data
D2post_pc <- function(se, fe, sc, fc, a, b, lCparam, lEparam, mu, sigma2, mycyc, priNormEC){

	gridc = seq(0.001, 0.999, by=0.001)
	midp1 = (0.00001 + 0.001)*0.5
	midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)

    wc  = vector(mode="numeric", length=lc)
    wc[1] = (gridc[3]-gridc[1])/6.0
    wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
    for(i in seq(2, lc-1, by=2)){
		wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
	}
    for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
	} 
	
	gride = gridc
	gridea = gridc
  	gridca = gridc
	we = wc
	le = lc
	
  	denspe = vector(mode="numeric", length = le)
  	intpc = vector(mode="numeric", length = lc)
  	intpea = vector(mode="numeric", length = le)
  	
  	for(j in 1:le){
  		const1 = dnorm(log(gridea*(1-gride[j])/(gride[j]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    	dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
		intpea[j] = sum(wc*dens)
  	}
  	
  	for(i in 1:lc){
  		const1 = dnorm(log(gridca*(1-gridc[i])/(gridc[i]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    	dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    	intpca = sum(wc*dens)
  		for(j in 1:le){	
    		const1 = dnorm(log(gride[j]*(1-gridc[i])/(gridc[i]*(1 - gride[j]))), mean = mu, sd = sqrt(sigma2))
    		denspe[j] = priNormEC*const1*intpca*intpea[j]*dbeta(gridc[i], shape1=a, shape2=b)/(gride[j]*(1-gride[j]))
    		denspe[j] = denspe[j]*(gride[j]^se)*((1-gride[j])^fe)
  		}
  		intpc[i] = sum(we*denspe)*(gridc[i]^sc)*((1-gridc[i])^fc)
  	}
	
	postNormEC = 1/sum(wc*intpc)
	intpc = postNormEC*intpc
	

	## Calculate summaries of the posterior distribution of pC
	## Checking to see whether posterior marginal probability that pC is in [0.001, 0.999] is less
   	## than would be the case under a flat Beta(1,1) density.
   	lim1 = as.double(0.001)
	lim2 = as.double(0.999)
	
   	gridc1 = gridc[which(gridc >= lim1 & gridc <= lim2)]
   	int1 = intpc[which(gridc >= lim1 & gridc <= lim2)]
   	lc1 = length(gridc1)
   	wc1  = vector(mode="numeric", length=lc1)
  	wc1[1] = (gridc1[3]-gridc1[1])/6.0
  	wc1[lc1] = (gridc1[lc1] - gridc1[lc1-2])/6.0
 	for(i in seq(2, (lc1-1), by=2)){
		wc1[i] = 4*(gridc1[i+1] - gridc1[i-1])/6.0
	}
	for(i in seq(3, (lc1-2), by=2)){
    	wc1[i] = (gridc1[i+2] - gridc1[i-2])/6.0
 	}
    istop = sum(wc1*int1)
   	if(istop < (lim2-lim1)){
      	stop("Error evaluating posterior density of pC: can't guarantee accuracy of numerical integration routines when integrating U (or L) shaped function \n")
   	}else{
   		## calculate the posterior mean and variance of pc
		expect = sum(wc*gridc*intpc)
		sdev = sqrt(sum(wc*gridc*gridc*intpc) - (expect^2))
		modecal = data.frame(gridc, intpc)
		modelcal_sort = modecal[order(intpc, decreasing = TRUE), ]
		mode1 = modelcal_sort$gridc[1] 
    	
    	ci_low = 0
    	ci_upp = 0
		return(data.frame(expect, sdev, mode1, ci_low, ci_upp, postNormEC))	
	}
}

## Function inputs: 	se, fe, sc, fc = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						a, b = parameters of Beta(a, b) prior distribution of pC representing what is known without the MYCYC data
##						lCparam, lEparam = parameters (mean, variance) of normal prior distributions for lambdaC and lambdaE
##						mu, sigma2 = mean, variance of normal prior for theta representing what is known without the MYCYC data
##						mycyc = vector containing summaries of mycyc data
##						priNormEC = normalising constant of prior density for (pE, pC)|zr, where zr = mycyc data
## Function returns: dataframe containing summaries of posterior distribution of pC (mean, mode, SD) when priors incorporate MYCYC data
##					and normTC = normalising constant for the joint posterior density of (pC, theta)|data, zr, where data = (se, fe, sc, fc) and zr = mycyc data

D2post_theta <- function(se, fe, sc, fc, a, b, lCparam, lEparam, mu, sigma2, mycyc, priNormEC){
	 
	gridc = seq(0.001, 0.999, by=0.001)
	midp1 = (0.00001 + 0.001)*0.5
	midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)

    wc  = vector(mode="numeric", length=lc)
    wc[1] = (gridc[3]-gridc[1])/6.0
    wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
    for(i in seq(2, lc-1, by=2)){
		wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
	}
    for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
	} 
	
	r = as.integer(16)
   	mesh = as.integer(6*r -1)
   	mesh1 = as.integer(2*mesh-1)
   	grid1 = vector(mode="numeric", length= mesh)
   	gridt = vector(mode="numeric", length= mesh1)
   	
   	for(i in 1:mesh){
   		if(i <= (r-1)){
   			grid1[i] = mu + sqrt(sigma2)*(-3-4*log(r/i))
   		}else if((i >= r) & (i<= 5*r)){
   			grid1[i] = mu + sqrt(sigma2)*(-3 + 3*(i-r)/(2*r))
   		}else{
   			grid1[i] = mu + sqrt(sigma2)*(3+ 4*log(r/(6*r -i)))
   		}
   	}   
	## calculating mesh mid-points 
   	for(i in seq(1, mesh, by=1)){
   		gridt[2*i-1] = grid1[i]	
   	}
   	for(i in seq(2, mesh1-1, by=2)){
   		gridt[i] = (gridt[i+1] + gridt[i-1])/2.0
   	}    
	## calculating Simpson's integration weights
   	wtheta  = vector(mode="numeric", length=mesh1)
    wtheta[1] = (gridt[3]-gridt[1])/6.0
  	wtheta[mesh1] = (gridt[mesh1] - gridt[mesh1-2])/6.0
  	for(i in seq(2, (mesh1-1), by=2)){
    	wtheta[i] = 4*(gridt[i+1] - gridt[i-1])/6.0
   	}
   	for(i in seq(3, (mesh1-2), by=2)){
		wtheta[i] = (gridt[i+2] - gridt[i-2])/6.0
   	}

	grider = gridc
	gridcr = gridc
	denspc = vector(mode="numeric", length=lc)
	int = vector(mode="numeric", length = mesh1)
	
	int1 = (grider^(mycyc[3] -1))*((1-grider)^(mycyc[4]-1))
  	int2 = (gridcr^(mycyc[1]-1))*((1-gridcr)^(mycyc[2]-1))
  	for(i in 1:mesh1){
  	## Integrate over joint density of (theta, pC)|zr, mypan data	
  		for(j in 1:lc){
  			phi = gridc[j]*exp(gridt[i])/(gridc[j]*(exp(gridt[i]) -1) +1)
  			int3 = int1*dnorm( log(grider*(1-phi)/(phi*(1-grider))), mean = lEparam[1], sd = sqrt(lEparam[2]))
  			int4 = int2*dnorm(log(gridcr*(1-gridc[j])/((1-gridcr)*gridc[j])), mean = lCparam[1], sd = sqrt(lCparam[2]))
  			denspc[j] = sum(wc*int3)*sum(wc*int4)*dbeta(gridc[j], shape1 = a, shape2=b)*priNormEC/(phi*(1-phi))
  			denspc[j] = denspc[j]*dnorm(log(phi*(1-gridc[j])/(gridc[j]*(1-phi))), mean = mu, sd = sqrt(sigma2))
  			denspc[j] = denspc[j]*(gridc[j]^(se+sc+1))*((1-gridc[j])^(fe+fc+1))/((gridc[j]*(exp(gridt[i]) -1) +1)^(se+fe+2))
  		}
  		int[i] = sum(wc*denspc)*exp((se+1)*gridt[i])
	}
	
	normTC = 1/sum(wtheta*int)
	int = normTC*int
	
	## Calculate summaries of the posterior distribution of theta
	expect = sum(wtheta*gridt*int)
	sdev = sqrt(sum(wtheta*gridt*gridt*int) - (expect^2))
	modecal = data.frame(gridt, int)
	modelcal_sort = modecal[order(int, decreasing = TRUE), ]
	mode1 = modelcal_sort$gridt[1]
	
 	ci_low = 0
 	ci_upp = 0
	return(data.frame(expect, sdev, mode1, ci_low, ci_upp, normTC))	
	
}